/* - GPSPositionFixStatusChangeListener -
 * Display the data from a GPS position fix status change event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.event.GPSPositionFixStatusChangeEvent;
import com.phidgets.event.GPSPositionFixStatusChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class GPositionFixStatusChangeListener implements GPSPositionFixStatusChangeListener {

    private JCheckBox fixStatusChk;
    private JTextField latTxt;
    private JTextField longTxt;
    private JTextField altTxt;
    private JTextField velTxt;
    private JTextField headTxt;

    public GPositionFixStatusChangeListener(JCheckBox fixStatusChk, JTextField latTxt, JTextField longTxt, JTextField altTxt, JTextField velTxt,
            JTextField headTxt) {
        this.fixStatusChk = fixStatusChk;
        this.latTxt = latTxt;
        this.longTxt = longTxt;
        this.altTxt = altTxt;
        this.velTxt = velTxt;
        this.headTxt = headTxt;
    }

    public void gpsPositionFixStatusChanged(GPSPositionFixStatusChangeEvent gpsPositionFixStatusChangeEvent) {
        try {
            fixStatusChk.setSelected(gpsPositionFixStatusChangeEvent.getStatus());
            if (gpsPositionFixStatusChangeEvent.getStatus() == false) {
                latTxt.setText("Unknown");
                longTxt.setText("Unknown");
                altTxt.setText("Unknown");
                velTxt.setText("Unknown");
                headTxt.setText("Unknown");
            }
        } catch (Exception ex) {
            System.out.println("exception");
        }
    }
}
